% Une implmentation X11/Xt des routines OGO de METAFONT.
% $Id: x11.w,v 1.4 2016/01/31 08:29:37 tlaronde Exp $

% in limbo
\lang=fr
\input lists
\datethis % dater le chef-d'oeuvre

\font\logo=logo10 % font used for the METAFONT logo
\def\MF{{\logo META}\-{\logo FONT}}

\def\author{Thierry LARONDE (tlaronde@@polynum.com)}
\def\copydate{2015}

% Numbers have to be adjusted when binding all the doc together
\skippage=1
\def\contentspagenumber{\startpage}
\pageno=\contentspagenumber \advance\pageno by \skippage

\def\topofcontents{\null\vfill
  \centerline{\titlefont Ker\TeX\ : rendu graphique X11 pour \MF}
  \vskip 1em
  \centerline{(bauche)}
  \centerline{\$Id: x11.w,v 1.4 2016/01/31 08:29:37 tlaronde Exp $$}
  \vskip 20pt
  \centerline{\mainfont \author}
  \vskip 20pt

% abstract will be included on first page

\centerline{\bf Abstract}
\medskip
If the host system offers a graphical 2D service, the \.{virmf}
\MF\ incarnations can have the abibity to display a rendering of
characters.

This is described in the \MF\ program as the {\bf Outline graphic 
output} part number 27 ; hence the {\sl ogo} acronym for the library.

The use of the routines, from an user point of view, is described in
the \MF book, chapter 23.

This is the X11 implementation of the \MF\ routines, using only
standard X11 features without using even the Xt library.

\bigskip
Copyright \copydate\ \author. All rights reserved.

This software is provided ``as is'' without any warranty, under the
ker\TeX\ public licence.

\smallskip
\hrule
\medskip
Si le systme hte offre un service de rendu graphique 2D, les
diverses incarnations \.{virmf} de \MF peuvent offrir la possibilit
d'afficher un rendu  l'cran des caractres programms.

Cela est dcrit dans le programme de \MF\ dans la partie 27 : {\bf
Online graphic output} d'o l'acronyme {\sl ogo} pour la bibliothque.

Du point de vue de l'utilisateur, l'emploi des routines, si elles sont
disponibles, est dcrit dans le \MF book, chapitre 24.

Ceci est l'implmentation des routines de \MF\ dvolues en utilisant ce
que le systme X11 fournit de manire normalise (X11), sans mme
utiliser Xt. 

\bigskip
Copyright \copydate\ \author. Tous droits rservs.

Ce logiciel est fourni en l'tat sans aucune garantie, sous la licence
publique de ker\TeX.

}

% format specifications for X11 strutures

@s Display char
@s Screen char
@s Window char
@s GC char
@s Pixmap char
@s XImage char


@** Vue d'ensemble.

Le rendu graphique se btit  partir de deux lments. Premirement, une
fentre dans laquelle dessiner quelque chose. Deuximement, le dessin
effectif de ce que nous voulons rendre dans cette fentre ddie.

@ \MF\ utilise le terme |screen| pour dsigner la portion 2D dans
laquelle il affiche car cet cran est par la suite subdivis en fentres
gres par le code indpendant du systme (cette bibliothque ne gre
donc pas ces sous-fentres). La remarque est d'ailleurs faite paragraphe
571.

@ Le lien entre le code \MF\ indpendant du systme et la partie
dpendante est fait par l'intermdiaire de certaines variables globales.

Les deux premires sont les dimensions de l'cran. Ces valeurs peuvent
tre particularises par l'utilisateur, sur la ligne de commande ou par
des variables d'environnement.

Un boolen indique, aprs initialisation, si l'cran est
OK. Cette variable est exporte car l'utilisateur, sur le terminal, peut
fermer la fentre.  l'interception d'un tel vnement, nous mettrons 
jour le boolen pour que les routines de modification du contenu ne
soient plus appeles (les routines de la prsente bibliothque ne 
vrifient donc pas le boolen ; cette vrification est faite dans
le code \MF\ indpendant du systme).

Enfin, un vecteur de transition, manipul par \MF,  sert  dfinir
ce qui doit tre dessin. Il est allou en fonction des valeurs de
|screenwidth| et |screendepth|.

@<Globals@>=
int screenwidth = MF_SCREEN_WIDTH_DEFAULT;
int screendepth = MF_SCREEN_DEPTH_DEFAULT;
boolean screenOK =  false;
int *rowtransition;

@ Parce que ker\TeX\ a l'objectif de fournir la mme chose, par
l'intermdiaire des mmes commandes, sur des systmes diffrents,
la fentre graphique sera minimale, sans menu, sans autonomie, et
sa gestion dpendra du programme \MF, par la ligne de commande et
par l'environnement. Nous n'utilisons pas les ressources propres
(facults d'adaptation) du systme hte graphique.

@* Initialisation de l'cran.

L'initialisation comporte une partie qui est bien entendu dpendante du
systme graphique hte, et une partie gnrique : l'allocation du
vecteur de transition, qui dpend de la taille effective de l'cran,
mais qui ne dpend pas du systme 2D.

Dans ce qui suit, nous tentons de mettre  part ce qui est indpendant
du systme graphique de ce qui en est dpendant.

@c
#include <assert.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
@<Host 2D headers@>@;
#include "pascal.h"
#include "ogo.h"
@<Globals@>@;

boolean
initscreen(void)
{
	if (screenwidth <= 0 || screendepth <= 0) {
		(void)fprintf(stderr, "The size of the screen (%d,%d) is invalid!\n",
			screenwidth, screendepth);
		return false;
	}
	@<Create and allocate host 2D resources; return |false| on error@>@;
	@<Allocate |rowtransition|; return |false| on error@>@;
	updatescreen(); /* initial blanking */

	return true;
}

@ L'allocation du vecteur de transition dpend des tailles effectives
de l'cran (le systme peut ne pas allouer ce qui a t demand), mais
sinon le code ne dpend pas du systme.

@<Allocate |rowtransition|; return |false| on error@>=
assert(screenwidth > 0);
if ( (rowtransition = (int *)malloc(screenwidth * sizeof(int))) == NULL)
	return false;

@ En cas de fermeture de l'cran ou de tout autre problme, nous
commenons par invalider toute mise  jour de l'cran et librons 
le vecteur de transition.

@<Free all resources allocated and invalidate screen updates@>=
screenOK = false;
free(rowtransition);
rowtransition = NULL;

@ Pour X11, la procdure consiste  commencer par se connecter au
serveur, condition {\it sine qua non} pour pouvoir allouer des
ressources et afficher quelque chose.

Si cela russit, on cre notre cran (notre fentre dans la terminologie
X11) et on cre galement une image de sauvegarde : tous les tracs sont
faits dans l'image, et c'est cette image qui est affiche.

Aprs avoir affich l'cran \MF\ sur l'cran X11, on dmarre par une
fentre vide (remplie de la couleur d'arrire-plan).

Une fois la fentre cre et initialise, nous nous occuperons du dessin
par le biais d'une |Ximage| et d'un |bitmap|.

@<Host 2D headers@>=
#include <X11/Xlib.h>
#include <X11/Xutil.h> /* |XSizeHints| and window properties */
#include <X11/Xatom.h>

@ @<Create and allocate host 2D resources; return |false| on error@>=
@<Try to connect to the X11 server; return false on error@>@;
@<Create the |mfwin| X11 window@>@;
@<Retrieve |mfwin| attributes@>@;
@<Adjust |mfwin| attributes@>@;
@<Allocate the corresponding |gc|@>@;
@<Allocate the drawing into |mfwin| resources@>@;
XMapWindow(display, mfwin);

@ La connexion au serveur se fait, pour nous --- puisque, rappelons-le,
nous voulons une mme exprience utilisateur quel que soit l'hte ---,
via l'environnement.  l'utilisateur de dfinir correctement |DISPLAY|.

@<Globals@>=
static Display *display;
static int iscreen;
static Screen *screen;

@ @<Try to connect to the X11 server; return false on error@>=
if ( (display = XOpenDisplay(NULL)) == NULL ) {
	(void)fprintf(stderr, "%s: unable to connect to X11 server.\n",
		argv[0]);
	return false;
}
iscreen = DefaultScreen(display);
screen = DefaultScreenOfDisplay(display);

@ Pour X11, |screen| est le priphrique graphique en entier, et une
portion de ce priphrique dans laquelle tracer est une |Window| qui
peut recouvrir l'intgralit de l'cran (mais les fentres s'empilent,
tandis que l'cran est toujours unique).

L'identifiant de la fentre correspondant au |screen| de \MF\ sera donc 
|mfwin|.

@<Globals@>=
static Window mfwin;
static unsigned long bg, fg;

@ Si la largeur de l'cran de \MF\ porte le nom |screenwidth|, la
hauteur de la fentre porte le nom |screendepth|, ce qui n'est pas le
nom gnralement utilis avec X11, o la profondeur est lie au nombre
de couleurs. En l'occurrence, c'est une profondeur, parce que les $y$
vont croissant de haut en bas : l'origine de la fentre est en haut 
gauche, ce qui correspond  la convention X11.

La fentre n'est qu'une fentre de rendu. Nous n'avons pas besoin de
curseur, de boutons, de menu d'autant que la fentre n'est pas une
application ddie qui grerait les vnements, mais est dpendante de
l'application \MF. Nous n'utiliserons donc que les routines \.{XLIB}
sans mme utiliser \.{Xt}.

Comme nous n'utilisons que deux couleurs contrastantes (qui ne sont pas
forcment du noir et du blanc), nous utilisons le visuel par dfaut de
la fentre racine et nous utilisons donc la routine de cration
simplifie.

Nous crons l'objet, mais rien n'est affich pour l'instant.

@<Create the |mfwin| X11 window@>=
bg = WhitePixel(display, iscreen);
fg = BlackPixel(display, iscreen);
mfwin = XCreateSimpleWindow(display, RootWindow(display, iscreen),
	0, 0, screenwidth, screendepth, 4, fg, bg);

@ La fentre cre peut avoir, ou pas, les dimensions spcifies.

On rcupre la dimension affecte.

@<Retrieve |mfwin| attributes@>=
{
XWindowAttributes mfwinattr;

if (XGetWindowAttributes(display, mfwin, &mfwinattr) == 0) {
	(void)fprintf(stderr, "%s: failed to get X11 window attributes.\n",
		argv[0]);
	return false;
}
screenwidth = mfwinattr.width;
screendepth = mfwinattr.height;
}

@ Qui plus est, comme cette fentre n'est, rellement, qu'en affichage,
et qu'elle est totalement dpendante de \MF, la mise  jour de
l'affichage ne se fait qu'explicitement par l'appel des routines
utilisateur au niveau de \MF.

Si le serveur permet le |Backing Store|, autant l'utiliser.

Sinon, nous ne nous intressons qu'aux vnements de mise au jour ({\it
exposure}) et aux vnements de destruction de la fentre.

@<Adjust |mfwin| attributes@>=
{
XSetWindowAttributes setmfwinattr;

setmfwinattr.backing_store = Always;
setmfwinattr.save_under = True;
setmfwinattr.event_mask = ExposureMask | StructureNotifyMask;
XChangeWindowAttributes(display, mfwin, 
	CWBackingStore|CWSaveUnder|CWEventMask,
	&setmfwinattr);
}

@ Dans tous les cas, |updatescreen| devra ``profiter'' de son appel pour
traiter la queue des vnements slectionns ci-dessus. Mais il s'agit
d'une procdure appele  la demande : le traitement des vnements ne
doit donc pas bloquer.

@<Process the X11 events queue, setting |screenOK| to |false| if |mfwin|
disappeared@>=
{
XEvent event;

while (XCheckWindowEvent(display, mfwin, 
	ExposureMask|StructureNotifyMask, &event) == True) {
	switch (event.type) {
		case UnmapNotify:
			XDestroyWindow(display, mfwin);
			/* FALLTHRU */
		case DestroyNotify:
			@<Free all resources allocated and invalidate screen updates@>@;
			return;
			break;
		default:
			break;
	}
}
}

@ Pour dessiner dans la fentre, nous allouons sur le serveur un |gc|,
dont les paramtres sont basiques.

Nous slectionnons une paisseur de ligne de $1$ car $0$ entrane
l'utilisation d'un algorithme rapide qui peut ne pas donner des
rsultats trs fins. (Bien qu'en l'occurrence, cela n'ait aujourd'hui
pas d'importance compte tenu de notre usage.)

@<Globals@>=
static GC gc;

@ @<Allocate the corresponding |gc|@>=
{
XGCValues gcvalues;

gcvalues.foreground = fg;
gcvalues.background = bg;
gcvalues.function = GXcopy; /* default */
gcvalues.line_width = 1; /* 0 is simplified rendering */
gc = XCreateGC(display, mfwin,
	(GCFunction | GCForeground | GCBackground | GCLineWidth), &gcvalues);
}

@ La mise  jour de ce qui s'affiche dans la fentre sera la simple
copie d'une image, mise  jour ligne par ligne par |paintrow|, et
dont des portions rectangulaires auront ventuellement t blanchies
par |blankrectangle|.

Pour l'instant, c'est un ``bitmap'' puisque nous n'utilisons que deux
couleurs (rappelons qu'elles ne sont pas obligatoirement le noir et le
blanc mais deux couleurs contrastantes pour le visuel utilis).

En l'occurrence, pour viter la lourdeur des changes avec le serveur
quand nous composons, pixel par pixel, le dessin, une image (donc ct
client) sera utilise, cependant qu'un |bitmap| (|pixmap| de profondeur
1) sera allou au niveau du serveur et sera recopie dans la fentre.

@ Nous allons donc allouer le correspondant au niveau du client du
bitmap,  savoir une |XImage|. Le vecteur de donnes n'est pas cr ;
par contre, si le pointeur dans la structure n'est pas nil, la
destruction entrane la libration du vecteur de donnes.

@<Globals@>=
XImage *img;
int bytes_per_line;

@ Le vecteur sera allou continment, mais chaque ligne est bien entendu
un nombre entiers d'octets. Il faut donc arrondir  l'entier
immdiatement suprieur ou gal.

@<Allocate the drawing into |mfwin| resources@>=
bytes_per_line = (screenwidth + 7) / 8;
if ( ( (img = XCreateImage(display, DefaultVisual(display, iscreen),
	1, XYBitmap, 0, None, screenwidth, screendepth, 8, bytes_per_line))
	== NULL ) 
	|| ( (img->data = (char *)calloc((size_t) (bytes_per_line * screendepth),
	sizeof(char))) == NULL ) ) {
	(void)fprintf(stderr, "%s: unable to allocate X11 Ximage.\n",
		argv[0]);
	@<Free all resources allocated and invalidate screen updates@>@;
	return false;
}

@ @<Free all resources allocated and invalidate screen updates@>=
if (img != NULL) XDestroyImage(img); /* release data too if not nil */

@ La routine |updatescreen| va donc traiter les vnments en attente,
remettre  zro l'cran (le blanchir), mettre  jour le masque |bitmap|
et remplir la fentre ``au pochoir''.

@c
void
updatescreen(void)
{
	@<Process the X11 events queue...@>@;
	XPutImage(display, mfwin, gc, img, 0, 0, 0, 0,
		screenwidth, screendepth);
	XFlush(display); /* since no input so not automatically done */
}

@* Les routines de dessin.

Les routines de dessin proprement dit ne dpendent pas de l'affichage :
on compose l'image avant d'utiliser |updatescreen| pour mettre  jour
l'cran (la fentre) \MF.

Les routines sont dj pour l'essentiel implmentes en commentaire dans
le fichier WEB de \MF, et nous ne faisons qu'adapter pour des
manipulations de bits.

@d white '\0'
@d black '\1'

@ Blanchir un rectangle, c'est simplement mettre  $0$ les bits dans le
rectangle, se rappelant que la borne suprieure est exclue (voir le code
comment dans \MF).

@c
void
blankrectangle(int left_col, int right_col, int top_row, int bot_row)
{
	int r, c;
	char *row;

	for (r = top_row; r < bot_row; ++r) {
		row = img->data + r * bytes_per_line;
		for (c = left_col; c < right_col; c++)
			row[c/8] &= ~(black << (c%8));
	}
}

@ Le vecteur de transition indique des intervalles alterns : la
premire colonne ayant la couleur passe, la dernire colonne ayant la
couleur passe (dernire colonne exclue). Forcment, l'intervalle
suivant n'a pas la mme couleur, ce pourquoi on change.

@c
void
paintrow(int r, signed char b, int *a, int n)
{
	int k, c;
	char *row;

	row = img->data + r * bytes_per_line;
	k = 0;
	c = a[0]; /* start column */
	do {
		++k;
		do {
			row[c/8] = ( row[c/8] & ~(black << (c%8)) ) | (b << (c%8));
			c++;
		} while (c != a[k]);
		b = black - b; /* swap black<->white */
	} while (k != n);
}

@** Index.

Voici une liste des identifiants utiliss et de leurs occurrences. Les
entres sous-lignes indiquent l'endroit de leur dfinition.
