/* $Id: abi.h,v 1.2 2004/07/26 19:02:34 tlaronde Exp $
 * Copyright 2004 Thierry LARONDE <tlaronde@polynum.com>
 * All rights reserved. 
 * 
 * This work is under the KerGIS Public Licence v1.0
 *
 * See the COPYRIGHT file at the root of the source directory or see
 * http://www.kergis.org/licence.txt for complete information.
 *
 *!!!THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES!!! 
 *                     USE IT AT YOUR OWN RISK 
 ********************************************************************/
#include <limits.h>

/* Size of char */
#ifdef CHAR_BIT
#if CHAR_BIT == 8
#define CHAR_IS_BYTE
@@CHAR=BYTE
#else
@@CHAR=NOT_POSIX
#endif
#else /* not defined */
@@CHAR=NOT_ISO_C
#endif

/* Remaining will only work with BYTE chars (8 bits) */
#ifdef CHAR_IS_BYTE

/* Size of short */
#ifdef USHRT_MAX
#if UINT_MAX < 0xffff
@@SHORT=NOT_POSIX
#elif USHRT_MAX == (1 << 16) - 1
@@SHORT=WYDE
#elif USHRT_MAX == (1 << 32) - 1
@@SHORT=TETRA
#elif USHRT_MAX == (1 << 64) - 1
@@SHORT=OCTA
#else
@@SHORT=UNKNOWN
#endif
#else
@@SHORT=NOT_ISO_C
#endif /* USHRT_MAX */ 

/* Size of int */
#ifdef UINT_MAX
#if UINT_MAX < 0xffffffff
@@INT=NOT_POSIX
#elif UINT_MAX == (1 << 32) - 1
@@INT=TETRA
#elif UINT_MAX == (1 << 64) - 1
@@INT=OCTA
#else
@@INT=UNKNOWN
#endif
#else
@@INT=NOT_ISO_C
#endif /* UINT_MAX */

/* Size of long */
#ifdef ULONG_MAX
#if ULONG_MAX < 0xffffffff
@@LONG=NOT_POSIX
#elif ULONG_MAX == (1 << 32) - 1
@@LONG=TETRA
#elif ULONG_MAX == (1 << 64) - 1
@@LONG=OCTA
#else
@@LONG=UNKNOWN
#endif
#else
@@LONG=NOT_ISO_C
#endif /* ULONG_MAX */

#endif /* CHAR_IS_BYTE */

/* TODO IEEE/ISO standard 754 correct support 
 * single precision is 32 bits
 * double precision is 64 bits
 * but an implementation can have only double precision (on octabyte
 * computers) */

#include <float.h>

#ifdef FLT_MANT_DIG
#if FLT_MANT_DIG == 24
@@FLOAT=TETRA
#else
@@FLOAT=UNKNOW
#endif
#else
FLOAT=NOT_ISO_C
#endif

#ifdef DBL_MANT_DIG
#if DBL_MANT_DIG == 53
@@DOUBLE=OCTA
#else
@@DOUBLE=UNKNOW
#endif
#else
DOUBLE=NOT_ISO_C
#endif
